function comp2strains(s1n, s1, s2n, s2, s3n, s3, normflag, wavelength) 
% This is a helper function used to compare the pumping response of 2
% different mutant strains.  s1 and s2 are the data in cell array form.
% By default, this program graphs the mean and 1.96 * the standard error as
% shading.

%20140918, ss: I modified comp2strains to accomodate 3 strains for
%complementation tests, rescue, etc. In doing this, I simply copied every
%appearance of code related to strain 2 and renamed it to strain 3.

startDelay = 10;
nTimes = 3;
period = 10;
winWidth = 1000;
yMax = 6.5;
eventName = 'pumping rate (Hz)';
yBar = 6;
numMsInS = 1000;
%errC = 2.576; % p = 0.01
%errC = 1.960;  % p = 0.05
errC = 1;

totalTime = startDelay + (nTimes - 1)*period;

if strcmp(wavelength, '365') %sloppy way to change color of light bar if light using uv light
    lightc = [0 0 0] ./ 255;
else
    lightc = [98 0 255] ./ 255;  %VIOLET % [0 32 255] ./ 255; %BLUE          % Color of light bar
end

linecm = [0 0 0; 
          255 51 0;
          13 30 217;
          %0  0 255;
          ] ./ 255;  % Color of 2 mean lines
patchcm = [171 171 171; 
            255 214 126;
            20 227 179;
           % 204 204 255;
            ] ./ 255;  % Color of 2 error regions around the mean

[s1m s1sd] = eventsOverTime(s1, totalTime*numMsInS, winWidth, numMsInS, eventName, false);
s1e = s1sd / sqrt(length(s1));
s1e = errC*s1e;

[s2m s2sd] = eventsOverTime(s2, totalTime*numMsInS, winWidth, numMsInS, eventName, false);
s2e = s2sd / sqrt(length(s2));
s2e = errC*s2e;

[s3m s3sd] = eventsOverTime(s3, totalTime*numMsInS, winWidth, numMsInS, eventName, false);
s3e = s3sd / sqrt(length(s3));
s3e = errC*s3e;


if (normflag)
    s1norm = mean(s1m(1:startDelay*numMsInS));
    s1m = s1m/s1norm;
    s1sd = s1sd/s1norm;
    s1e = s1sd / sqrt(length(s1));
    s1e = errC*s1e;

    s2norm = mean(s2m(1:startDelay*numMsInS));
    s2m = s2m/s2norm;
    s2sd = s2sd/s2norm;
    s2e = s2sd / sqrt(length(s2));
    s2e = errC*s2e;

    s3norm = mean(s3m(1:startDelay*numMsInS));
    s3m = s3m/s3norm;
    s3sd = s3sd/s3norm;
    s3e = s3sd / sqrt(length(s3));
    s3e = errC*s3e;

    
    
    yMax = 1.8;
    
    yBar=1.4
end

h=figure;
hold on

x = winWidth/numMsInS/2:(1/numMsInS):totalTime-winWidth/numMsInS+winWidth/numMsInS/2;

patch([x x(end:-1:1)], [s1m+s1e s1m(end:-1:1)-s1e(end:-1:1)], patchcm(1,:),'LineStyle','none');
patch([x x(end:-1:1)], [s2m+s2e s2m(end:-1:1)-s2e(end:-1:1)], patchcm(2,:),'LineStyle','none');
patch([x x(end:-1:1)], [s3m+s3e s3m(end:-1:1)-s3e(end:-1:1)], patchcm(3,:),'LineStyle','none');


h(1) = plot(x, s1m, 'LineWidth', 2, 'Color', linecm(1,:)); %the  4th argument adjusts line thickness, the 2nd and 6th ajdust line and error color -steve
h(2) = plot(x, s2m, 'LineWidth', 2, 'Color', linecm(2,:));
h(3) = plot([startDelay startDelay+period], [yBar yBar], 'LineWidth', 16, 'Color', lightc);
h(4) = plot(x, s3m, 'LineWidth', 2, 'Color', linecm(3,:));


%t = title([eventName ' for ' s2n ' (mean \pm ' num2str(errC) ' sem, n = ' ...
%          num2str(length(s2)) ')'], 'FontWeight', 'bold', 'FontSize', 16);
%those 2 lines above the old title system

%h = title([s1n ' v \it\color{orange}' s2n], 'FontWeight', 'bold',
%'FontSize', 16); %the old title protram - now I'm using text (below)
h = text(3.2, 6.9, [s1n ' v \it\color{orange}' s2n ' v \it\color{blue}' s3n ],'FontWeight', 'bold', 'FontSize', 16);
%added the above to move the title to the left side of the page and changed
%the title from Nikhi's original to better fit my group meeting slides.
%Note that I'm now using a 'text' object instead of a 'title' object - text
%persists between saves, unlike a title which always returns.

 %set(t, 'interpreter', 'none');  % Turn off _ causing subscripts
xlabel('time (s)', 'FontWeight', 'Bold', 'FontSize', 12);
ylabel([eventName], 'FontWeight', 'Bold', 'FontSize', 12);
prettify();
axis([winWidth/numMsInS/2 totalTime-winWidth/numMsInS+winWidth/numMsInS/2 0 yMax]);

yts = 0:1:yMax;
set(gca, 'YTick', yts); 

%legend(h, s1n, s2n, stimn);
if strcmp(wavelength, '365')
    text(15, yBar, '365 nm light',...
     'FontWeight', 'bold', 'FontSize', 10, 'Color', [1 1 1], ...
     'HorizontalAlignment', 'center');


 %text(12.5, yMax-.35, stimn, 'FontWeight', 'bold');
elseif strcmp(wavelength, '436')
    text(15, yBar, '436 nm light',...
     'FontWeight', 'bold', 'FontSize', 10, 'Color', [1 1 1], ...
     'HorizontalAlignment', 'center');
%text(12.5, yMax-.35, stimn, 'FontWeight', 'bold');
else
    text(15, yBar, 'light',...
     'FontWeight', 'bold', 'FontSize', 10, 'Color', [1 1 1], ...
     'HorizontalAlignment', 'center');


if(s1m(end) > s2m(end))
    y1 = s1m(end) + 0.4;
    y2 = s2m(end) - 0.6;
else
    y1 = s1m(end) - 0.6;
    y2 = s2m(end) + 0.4;
end
%{
text(x(end), y1, s1n, ...
     'FontWeight', 'bold', 'FontSize', 24, 'Color', linecm(1,:), ...
     'HorizontalAlignment', 'right', 'VerticalAlignment', 'bottom');
text(x(end), y2, s2n, ...
     'FontWeight', 'bold', 'FontSize', 24, 'Color', linecm(2,:), ...
     'HorizontalAlignment', 'right', 'VerticalAlignment', 'bottom');
%}
 
prettify();



end
s2rename1=strrep(s2n, '-','');
s2rename2=strrep(s2rename1, '(', '_');
s2rename3=strrep(s2rename2, ')', '_')

s3rename1=strrep(s3n, '-','');
s3rename2=strrep(s3rename1, '(', '_');
s3rename3=strrep(s3rename2, ')', '_')


test=[s1];
%date=strsplit()

ds = datestr(now, 'yyyymmdd')
name=[s1n 'v_' s2rename3 'v_' s3rename3 ds];
saveFigure([name])

%for a future goal, it would be cool to 1. get the date out of the original
%file so that you don't have to make the plot the day of and 2. it to
%automatically save files into the right folders.
